options nocenter linesize=80 pagesize=59;
libname current '';

data subsx;

   array benefits {6,50}

         /* 1 - TANF receipt month indicators, primary leaver: */
         tnfrbm24 tnfrbm23 tnfrbm22 tnfrbm21 tnfrbm20 tnfrbm19 
         tnfrbm18 tnfrbm17 tnfrbm16 tnfrbm15 tnfrbm14 tnfrbm13
         tnfrbm12 tnfrbm11 tnfrbm10 tnfrbm09 tnfrbm08 tnfrbm07 
         tnfrbm06 tnfrbm05 tnfrbm04 tnfrbm03 tnfrbm02 tnfrbm01
         tnfram00      
         tnfram01 tnfram02 tnfram03 tnfram04 tnfram05 tnfram06 
	 tnfram07 tnfram08 tnfram09 tnfram10 tnfram11 tnfram12 
         tnfram13 tnfram14 tnfram15 tnfram16 tnfram17 tnfram18
         tnfram19 tnfram20 tnfram21 tnfram22 tnfram23 tnfram24  
         tnfram25 

	 /* 2 - Medicaid enrollment month indicators, primary leaver: */
         medrbm24 medrbm23 medrbm22 medrbm21 medrbm20 medrbm19 
         medrbm18 medrbm17 medrbm16 medrbm15 medrbm14 medrbm13
         medrbm12 medrbm11 medrbm10 medrbm09 medrbm08 medrbm07 
         medrbm06 medrbm05 medrbm04 medrbm03 medrbm02 medrbm01
         medram00        
         medram01 medram02 medram03 medram04 medram05 medram06 
	 medram07 medram08 medram09 medram10 medram11 medram12 
         medram13 medram14 medram15 medram16 medram17 medram18
         medram19 medram20 medram21 medram22 medram23 medram24  
         medram25 

         /* 3 - Medicaid enrollment month indicators, anyone in the case: */  
         medtbm24 medtbm23 medtbm22 medtbm21 medtbm20 medtbm19 
         medtbm18 medtbm17 medtbm16 medtbm15 medtbm14 medtbm13
         medtbm12 medtbm11 medtbm10 medtbm09 medtbm08 medtbm07 
         medtbm06 medtbm05 medtbm04 medtbm03 medtbm02 medtbm01
         medtam00        
         medtam01 medtam02 medtam03 medtam04 medtam05 medtam06 
	 medtam07 medtam08 medtam09 medtam10 medtam11 medtam12 
         medtam13 medtam14 medtam15 medtam16 medtam17 medtam18
         medtam19 medtam20 medtam21 medtam22 medtam23 medtam24  
         medtam25 


	 /* 4 - Medicaid enrollment month indicators, any child:  */  
         /* changed name of variable from childmed_bm## to chldbm## */
         chldbm24 chldbm23 chldbm22 chldbm21
         chldbm20 chldbm19 chldbm18 chldbm17 
	 chldbm16 chldbm15 chldbm14 chldbm13
         chldbm12 chldbm11 chldbm10 chldbm09
         chldbm08 chldbm07 chldbm06 chldbm05 
         chldbm04 chldbm03 chldbm02 chldbm01
         chldam00 chldam01 chldam02 chldam03 
         chldam04 chldam05 chldam06 chldam07
         chldam08 chldam09 chldam10 chldam11
         chldam12 chldam13 chldam14 chldam15
         chldam16 chldam17 chldam18 chldam19 
         chldam20 chldam21 chldam22 chldam23
	 chldam24 chldam25 

         /* 5 - Food Stamp receipt month indicators, primary leaver: */
         foodbm24 foodbm23 foodbm22 foodbm21 foodbm20 foodbm19 
         foodbm18 foodbm17 foodbm16 foodbm15 foodbm14 foodbm13
         foodbm12 foodbm11 foodbm10 foodbm09 foodbm08 foodbm07 
         foodbm06 foodbm05 foodbm04 foodbm03 foodbm02 foodbm01
         foodam00        
         foodam01 foodam02 foodam03 foodam04 foodam05 foodam06 
	 foodam07 foodam08 foodam09 foodam10 foodam11 foodam12  
         foodam13 foodam14 foodam15 foodam16 foodam17 foodam18
         foodam19 foodam20 foodam21 foodam22 foodam23 foodam24  
         foodam25 

         /* 6 - Medicaid enrollment month indicators, second adult: */
         a2mdbm24 a2mdbm23 a2mdbm22 a2mdbm21 a2mdbm20 a2mdbm19 
         a2mdbm18 a2mdbm17 a2mdbm16 a2mdbm15 a2mdbm14 a2mdbm13
         a2mdbm12 a2mdbm11 a2mdbm10 a2mdbm09 a2mdbm08 a2mdbm07 
         a2mdbm06 a2mdbm05 a2mdbm04 a2mdbm03 a2mdbm02 a2mdbm01
         a2mdam00        
         a2mdam01 a2mdam02 a2mdam03 a2mdam04 a2mdam05 a2mdam06 
	 a2mdam07 a2mdam08 a2mdam09 a2mdam10 a2mdam11 a2mdam12 
         a2mdam13 a2mdam14 a2mdam15 a2mdam16 a2mdam17 a2mdam18
         a2mdam19 a2mdam20 a2mdam21 a2mdam22 a2mdam23 a2mdam24  
         a2mdam25 ;

      infile 'c:\IL-subsX.asc' lrecl=850 pad missover;
      input 
       @001  recKey
       @012  exitcntr  2.       /* nth exit for this case  */
       @015  earnbq01  6. 
       @022  earnaq00  6. 
       @029  earnaq01  6. 
       @036  earnaq02  6. 
       @043  earnaq03  6.
       @050  earnaq04  6.
       @057  earnaq05  6.
       @064  earnaq06  6. @;
       ptr= 71 ;

     /* casehead TANF receipt:  */
       do i=1 to 50;
          input @ptr benefits {1,i} 3. @ ;
          ptr+3;
       end;     

      ***  exitdate in 2 different formats for THIS exit:           ;
      input 
         @222 SubsExit         /* mmyyyy  - equivalent to ExitDate  */
         @229 Subscoht $7.  @ ;    /* yyyy-mm - equivalent to cohort_t  */
         ptr= 237 ;

        do t=2 to 5;
          /* 2:  @237 casehead Medicaid enrollment:  */
          /* 3:  @388 Medicaid enrollment for anyone in the former case:  */
          /* 4:  @539 Medicaid enrollment for any child in the former case: */
          /* 5:  @690 casehead Food Stamp enrollment:  */
          do i=1 to 50;
             if benefits {t,i}=. then benefits {t,i}=0;
             input @ptr benefits {t,i} 3. @ ;
             ptr+3;
          end;
         ptr + 1 ; 
        end; 
run;

proc freq; run;






